# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        return "C"
    
    # Check for hardcoded strategies in opponent's code
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"  # Exploit always-cooperate
    if always_defect:
        return "D"  # Avoid being exploited
    
    # Late-game strategy: defect in last 2 rounds
    if len(my_history) >= 8:
        return "D"
    
    # Mid-game strategy: tit-for-tat with forgiveness
    if opp_history[-1] == "D":
        if len(my_history) > 2 and opp_history[-2] == "D" and my_history[-1] == "D":
            return "C"  # Forgive after mutual defection
        return "D"  # Mirror defection
    else:
        return "C"  # Cooperate if opponent cooperated